﻿using System;

namespace gov.va.med.vbecs.Common.Log
{
    /// <summary>
    /// Log4NetLoggerLocator
    /// </summary>
    public class Log4NetLoggerLocator : ILoggerLocator
    {

        ///<Developers>
        ///	<Developer>Denis Kozlov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>1/15/2013</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="1157"> 
        ///		<ExpectedInput>A valid type representing a logger type</ExpectedInput>
        ///		<ExpectedOutput>An instance of an ILogger object</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="782"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        ///Get Logger returns an instance of an ILogger object with a type matching the supplied type.
        /// </summary>
        /// <param name="type">Type of logger object</param>
        /// <returns>ILogger object instance</returns>
        public ILogger GetLogger(Type type)
        {
            return new Log4NetWrapper(type);
        }

        ///<Developers>
        ///	<Developer>Denis Kozlov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>1/15/2013</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="1157"> 
        ///		<ExpectedInput>A valid string representing a logger name</ExpectedInput>
        ///		<ExpectedOutput>An instance of an ILogger object</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="782"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        ///Get Logger returns an instance of an ILogger object with a name matching the supplied string.
        /// </summary>
        /// <param name="loggerName">Name of logger object</param>
        /// <returns>ILogger object instance</returns>
        public ILogger GetLogger(string loggerName)
        {
            return new Log4NetWrapper(loggerName);
        }
    }
}
